/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.output.DemuxOutputStream;

public class FileSystemUtils {
    private static final /* synthetic */ int WINDOWS = 1;
    private static final /* synthetic */ int POSIX_UNIX = 3;
    private static final /* synthetic */ int OS;
    private static final /* synthetic */ FileSystemUtils INSTANCE;
    private static final /* synthetic */ int OTHER = 0;
    private static final /* synthetic */ int UNIX = 2;
    private static final /* synthetic */ int INIT_PROBLEM = -1;

    public static long freeSpace(String a2) throws IOException {
        return INSTANCE.freeSpaceOS(a2, OS, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long parseBytes(String a2, String a3) throws IOException {
        try {
            long l2 = Long.parseLong(a2);
            if (l2 < 0L) {
                throw new IOException(new StringBuffer().insert(0, DemuxOutputStream.K("+s\u0005q\tr\f<\u0004u\u0006yH;\fzO<\fu\f<\u0006s\u001c<\u000eu\u0006xHz\u001ay\r<\u001bl\t\u007f\r<\u0001rHn\ro\u0018s\u0006o\r<\u000es\u001a<\u0018}\u001ctH;")).append(a3).append(FileFilterUtils.K("\f5\u000b{C}Hs\u000bhJlC8Bk\u000bnJtB|")).toString());
            }
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(new StringBuffer().insert(0, DemuxOutputStream.K("+s\u0005q\tr\f<\u0004u\u0006yH;\fzO<\fu\f<\u0006s\u001c<\u001ay\u001ci\u001arHr\u001dq\rn\u0001\u007fHx\th\t<\toHy\u0010l\r\u007f\u001cy\f<\u000es\u001a<\u0018}\u001ctH;")).append(a3).append(FileFilterUtils.K("\f5\u000b{C}Hs\u000bhJlC8Bk\u000bnJtB|")).toString());
        }
    }

    long parseDir(String a2, String a3) throws IOException {
        FileSystemUtils a4;
        int n2;
        int n3;
        int n4;
        block8: {
            int n5;
            char c2;
            int n6;
            block7: {
                n4 = 0;
                n3 = 0;
                int n7 = n6 = a2.length() - 1;
                while (n7 >= 0) {
                    c2 = a2.charAt(n6);
                    if (Character.isDigit(c2)) {
                        n3 = n6 + 1;
                        n5 = n6;
                        break block7;
                    }
                    n7 = --n6;
                }
                n5 = n6;
            }
            while (n5 >= 0) {
                c2 = a2.charAt(n6);
                if (!Character.isDigit(c2) && c2 != ',' && c2 != '.') {
                    n4 = n6 + 1;
                    n2 = n6;
                    break block8;
                }
                n5 = --n6;
            }
            n2 = n6;
        }
        if (n2 < 0) {
            throw new IOException(new StringBuffer().insert(0, DemuxOutputStream.K("_\u0007q\u0005}\u0006xHp\u0001r\r<Ox\u0001nH3E\u007fO<\fu\f<\u0006s\u001c<\u001ay\u001ci\u001arHj\tp\u0001xHu\u0006z\u0007<\u000es\u001a<\u0018}\u001ctH;")).append(a3).append(FileFilterUtils.K("?")).toString());
        }
        StringBuffer stringBuffer = new StringBuffer(a2.substring(n4, n3));
        int n8 = a2 = 0;
        while (n8 < stringBuffer.length()) {
            if (stringBuffer.charAt(a2) == ',' || stringBuffer.charAt(a2) == '.') {
                stringBuffer.deleteCharAt(a2--);
            }
            n8 = ++a2;
        }
        return a4.parseBytes(stringBuffer.toString(), a3);
    }

    public FileSystemUtils() {
        FileSystemUtils a2;
    }

    static {
        INSTANCE = new FileSystemUtils();
        int n2 = 0;
        try {
            String string = System.getProperty(DemuxOutputStream.K("s\u001b2\u0006}\u0005y"));
            if (string == null) {
                throw new IOException(FileFilterUtils.K("wX6EyF}\u000bvDl\u000b~DmE|"));
            }
            n2 = (string = string.toLowerCase()).indexOf(DemuxOutputStream.K("k\u0001r\fs\u001fo")) != -1 ? 1 : (string.indexOf(FileFilterUtils.K("tBv^`")) != -1 || string.indexOf(DemuxOutputStream.K("\u001bi\u0006<\u0007o")) != -1 || string.indexOf(FileFilterUtils.K("k^vDk")) != -1 || string.indexOf(DemuxOutputStream.K("o\u0007p\tn\u0001o")) != -1 || string.indexOf(FileFilterUtils.K("FhN7B`")) != -1 || string.indexOf(DemuxOutputStream.K("z\u001ay\r~\u001bx")) != -1 || string.indexOf(FileFilterUtils.K("BjB`")) != -1 || string.indexOf(DemuxOutputStream.K("\fu\u000fu\u001c}\u0004<\u001dr\u0001d")) != -1 || string.indexOf(FileFilterUtils.K("^vB`")) != -1 || string.indexOf(DemuxOutputStream.K("\u0005}\u000b<\u0007oHd")) != -1 ? 2 : (string.indexOf(FileFilterUtils.K("p[5^`")) != -1 || string.indexOf(DemuxOutputStream.K("}\u0001d")) != -1 ? 3 : 0));
        }
        catch (Exception exception) {
            n2 = -1;
        }
        OS = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long freeSpaceUnix(String a2, boolean a32, boolean a42) throws IOException {
        Object object;
        FileSystemUtils a5;
        String[] stringArray;
        if (a2.length() == 0) {
            throw new IllegalArgumentException(FileFilterUtils.K("{y_p\u000bu^k_8Ew_8I}\u000b}Fh_a"));
        }
        a2 = FilenameUtils.normalize(a2);
        String string = "-";
        if (a32) {
            string = new StringBuffer().insert(0, string).append(DemuxOutputStream.K("w")).toString();
        }
        if (a42) {
            string = new StringBuffer().insert(0, string).append(FileFilterUtils.K("H")).toString();
        }
        if (string.length() > 1) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = DemuxOutputStream.K("\fz");
            stringArray2[1] = string;
            stringArray = stringArray2;
            stringArray2[2] = a2;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = FileFilterUtils.K("O~");
            stringArray = stringArray3;
            stringArray3[1] = a2;
        }
        Object a32 = stringArray;
        a32 = a5.performCommand((String[])a32, 3);
        if (a32.size() < 2) {
            throw new IOException(new StringBuffer().insert(0, DemuxOutputStream.K("+s\u0005q\tr\f<\u0004u\u0006yH;\fzO<\fu\f<\u0006s\u001c<\u001ay\u001ci\u001arHu\u0006z\u0007<\toHy\u0010l\r\u007f\u001cy\f<\u000es\u001a<\u0018}\u001ctH;")).append(a2).append(FileFilterUtils.K("\f5\u000bjNk[wEkN8\\yX8")).append(a32).toString());
        }
        Object a42 = (String)a32.get(1);
        if (((StringTokenizer)(a42 = new StringTokenizer((String)a42, DemuxOutputStream.K("<")))).countTokens() < 4) {
            if (((StringTokenizer)a42).countTokens() != 1 || a32.size() < 3) throw new IOException(new StringBuffer().insert(0, DemuxOutputStream.K("+s\u0005q\tr\f<\u0004u\u0006yH;\fzO<\fu\f<\u0006s\u001c<\u001ay\u001ci\u001arHx\th\t<\toHy\u0010l\r\u007f\u001cy\f<\u000es\u001a<\u0018}\u001ctH;")).append(a2).append(FileFilterUtils.K("\f5\u000b{C}Hs\u000bhJlC8Bk\u000bnJtB|")).toString());
            string = (String)a32.get(2);
            object = a42 = new StringTokenizer(string, FileFilterUtils.K("8"));
        } else {
            Object object2 = a42;
            object = object2;
            ((StringTokenizer)object2).nextToken();
        }
        ((StringTokenizer)object).nextToken();
        ((StringTokenizer)a42).nextToken();
        string = ((StringTokenizer)a42).nextToken();
        return a5.parseBytes(string, a2);
    }

    public static long freeSpaceKb(String a2) throws IOException {
        return INSTANCE.freeSpaceOS(a2, OS, true);
    }

    long freeSpaceOS(String a2, int a3, boolean a4) throws IOException {
        if (a2 == null) {
            throw new IllegalArgumentException(DemuxOutputStream.K("8}\u001ctHq\u001do\u001c<\u0006s\u001c<\nyHy\u0005l\u001ce"));
        }
        switch (a3) {
            case 1: {
                FileSystemUtils a5;
                if (a4) {
                    return a5.freeSpaceWindows(a2) / 1024L;
                }
                return a5.freeSpaceWindows(a2);
            }
            case 2: {
                FileSystemUtils a5;
                return a5.freeSpaceUnix(a2, a4, false);
            }
            case 3: {
                FileSystemUtils a5;
                return a5.freeSpaceUnix(a2, a4, true);
            }
            case 0: {
                while (false) {
                }
                throw new IllegalStateException(FileFilterUtils.K("~vXm[hDj_}O8DhNjJlBvL8XaXlNu"));
            }
        }
        throw new IllegalStateException(DemuxOutputStream.K("-d\u000by\u0018h\u0001s\u0006<\u000b}\u001d{\u0000hHk\u0000y\u0006<\fy\u001cy\u001aq\u0001r\u0001r\u000f<\u0007l\rn\th\u0001r\u000f<\u001be\u001bh\rq"));
    }

    Process openProcess(String[] a2) throws IOException {
        return Runtime.getRuntime().exec(a2);
    }

    long freeSpaceWindows(String a2) throws IOException {
        int n2;
        FileSystemUtils a3;
        if ((a2 = FilenameUtils.normalize(a2)).length() > 2 && a2.charAt(1) == ':') {
            a2 = a2.substring(0, 2);
        }
        String[] stringArray = new String[3];
        stringArray[0] = FileFilterUtils.K("{F|\u0005}S}");
        stringArray[1] = DemuxOutputStream.K("G_");
        stringArray[2] = FileFilterUtils.K("OqY8\u00045H8") + a2;
        Object object = stringArray;
        object = a3.performCommand((String[])object, Integer.MAX_VALUE);
        int n3 = n2 = object.size() - 1;
        while (n3 >= 0) {
            String string = (String)object.get(n2);
            if (string.length() > 0) {
                return a3.parseDir(string, a2);
            }
            n3 = --n2;
        }
        throw new IOException(new StringBuffer().insert(0, DemuxOutputStream.K("_\u0007q\u0005}\u0006xHp\u0001r\r<Ox\u0001nH3E\u007fO<\fu\f<\u0006s\u001c<\u001ay\u001ci\u001arH}\u0006eHu\u0006z\u0007<\u000es\u001a<\u0018}\u001ctH;")).append(a2).append(FileFilterUtils.K("?")).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List performCommand(String[] a2, int a32) throws IOException {
        ArrayList<String> a32;
        ArrayList<String> arrayList = new ArrayList<String>(20);
        Process process = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        InputStream inputStream2 = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String string;
                FileSystemUtils a4;
                process = a4.openProcess(a2);
                inputStream = process.getInputStream();
                outputStream = process.getOutputStream();
                inputStream2 = process.getErrorStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string2 = string = bufferedReader.readLine();
                while (true) {
                    if (string2 == null || arrayList.size() >= a32) {
                        Process process2 = process;
                        process2.waitFor();
                        if (process2.exitValue() == 0) break;
                        throw new IOException(new StringBuffer().insert(0, DemuxOutputStream.K("_\u0007q\u0005}\u0006xHp\u0001r\r<\u001ay\u001ci\u001ar\rxHS;<\rn\u001as\u001a<\u000bs\fyH;")).append(process.exitValue()).append(FileFilterUtils.K("\f8MwY8HwFuJvO8")).append(Arrays.asList(a2)).toString());
                    }
                    string = string.toLowerCase().trim();
                    arrayList.add(string);
                    string = bufferedReader.readLine();
                    string2 = string;
                }
                if (arrayList.size() == 0) {
                    throw new IOException(new StringBuffer().insert(0, DemuxOutputStream.K("_\u0007q\u0005}\u0006xHp\u0001r\r<\fu\f<\u0006s\u001c<\u001ay\u001ci\u001arH}\u0006eHu\u0006z\u0007<\u000es\u001a<\u000bs\u0005q\tr\f<")).append(Arrays.asList(a2)).toString());
                }
                a32 = arrayList;
                arrayList = null;
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(new StringBuffer().insert(0, FileFilterUtils.K("hwFuJvO8GqE}\u000blCjNo\u000byE8bv_}Yj^h_}O]S{Nh_qDv\u000b?")).append(interruptedException.getMessage()).append(DemuxOutputStream.K("O<\u000es\u001a<\u000bs\u0005q\tr\f<")).append(Arrays.asList(a2)).toString());
            }
        }
        catch (Throwable throwable) {
            arrayList = null;
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream2);
            IOUtils.closeQuietly(bufferedReader);
            if (process == null) throw throwable;
            process.destroy();
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
        IOUtils.closeQuietly(inputStream2);
        IOUtils.closeQuietly(bufferedReader);
        if (process == null) return a32;
        process.destroy();
        return a32;
    }
}

